package jamezo97.clonecraft.gui;

import jamezo97.clonecraft.entity.clone.CloneOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;

public class ButtonCloneOption extends GuiButton{

	CloneOption option;
	
	public ButtonCloneOption(int par1, int par2, int par3, int par4, int par5, CloneOption option) {
		super(par1, par2, par3, par4, par5, "");
		this.option = option;
		updateText();
	}
	
	@Override
	public void drawButton(Minecraft par1Minecraft, int par2, int par3) {
		updateText();
		super.drawButton(par1Minecraft, par2, par3);
		
	}

	public void updateText(){
		this.displayString = option.getName() + ": " + (option.value()?"On":"Off");
	}

	@Override
	public boolean mousePressed(Minecraft par1Minecraft, int par2, int par3) {
		boolean pressed = super.mousePressed(par1Minecraft, par2, par3);
		if(pressed){
			option.set(!option.value());
			option.updateToServer();
		}
		return pressed;
	}
	
	

}
